class Pickup_Dollar extends UniversalSoldiersPickup;

#exec obj load file=..\Textures\Belt_fx.utx package=Belt_fx

#exec Texture Import File=Textures\Dollar.bmp Name=Dollar Group=Pickups MIPS=ON LODSET=2

#exec mesh import mesh=Dollar anivfile=Models\Dollar_a.3d datafile=Models\Dollar_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=Dollar x=0 y=0 z=0
#exec mesh sequence mesh=Dollar seq=All startframe=0 numframes=1

#exec meshmap new meshmap=Dollar mesh=Dollar
#exec meshmap scale meshmap=Dollar x=0.10156 y=0.10156 z=0.20313

event float BotDesireability(Pawn Bot)
{

	return (0); 

}

auto state Pickup
{	
	function Touch( actor Other )
	{
		local US_PRI IPRI;
		local int D;

		if ( ValidTouch(Other) && Other.IsA('PlayerPawn')) 
			{
			D = (Rand(10) + 1);
			US_PRI(PlayerPawn(Other).PlayerReplicationInfo).Money += D;
			PlayPickupMessage(PlayerPawn(Other));
			PlaySound (PickupSound,,2.5);
			Other.MakeNoise(0.2);		
			SetRespawn();	
			}
	

	}
	function BeginState()
	{

		SetTimer(1.0,True);
	
	}
}


defaultproperties
{
LifeTime=15
DrawType=DT_Mesh
Mesh=Mesh'Dollar'
CollisionRadius=26.00000
CollisionHeight=26.00000
MultiSkins(0)=Texture'Belt_fx.ShieldBelt.BlueShield'
MultiSkins(1)=Texture'Dollar'
PickupMessage="You picked up a few dollars"
ItemName="Dollar"
RespawnTime=0.000000
PickupViewMesh=Mesh'Dollar'
PickupSound=Sound'UnrealShare.Generic.RespawnSound'
ScaleGlow=2.000000
bCollideWhenPlacing=True
bRotatingPickup=True
RotationRate=(Roll=12500)
RotationRate=(Pitch=12250)
RotationRate=(Yaw=12000)
}
